unit Form_Component;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, Grids, DBGrids, ExtCtrls, RPanel, StdCtrls, DBKeyCombo,
  DBSearch, DBLocate, DBEditBtn, DBEditLkDlg, DBCtrls, Mask, DBEditDateDlg,
  FileCtrl, Buttons, DB, ShellApi, DBStatus, QBuilder, DBTables, TblStruc,
  DBDlg, DBLookupDialog, DBEditLctDlg, DBDateDialog, BDE;


type
  TFormComponent = class(TForm)
    PageControl1: TPageControl;
    TabBrowse: TTabSheet;
    TabEdit: TTabSheet;
    DBGrid1: TDBGrid;
    RPanel1: TRPanel;
    RPanel2: TRPanel;
    Label1: TLabel;
    Label2: TLabel;
    DBEdit2: TDBEdit;
    Label3: TLabel;
    DBMemo1: TDBMemo;
    Label4: TLabel;
    DBText1: TDBText;
    DBEditLkDlg1: TDBEditLkDlg;
    Label5: TLabel;
    DBEditDateDlg1: TDBEditDateDlg;
    DBNavigator1: TDBNavigator;
    DriveComboBox1: TDriveComboBox;
    FilterComboBox1: TFilterComboBox;
    DirectoryListBox1: TDirectoryListBox;
    FileListBox1: TFileListBox;
    TabAuthor: TTabSheet;
    AddBtn: TBitBtn;
    ExtractBtn: TBitBtn;
    SaveDlg: TSaveDialog;
    TabComplex: TTabSheet;
    DBStatus: TDBStatus;
    StatusBar: TStatusBar;
    RPanel3: TRPanel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    DBText2: TDBText;
    DBEdit3: TDBEdit;
    DBEdit4: TDBEdit;
    DBEdit5: TDBEdit;
    DBMemo2: TDBMemo;
    DBNavigator2: TDBNavigator;
    RPanel4: TRPanel;
    QBuilder: TQBuilder;
    ThreadQuery: TThreadQuery;
    DQCompSource: TDataSource;
    DQComp: TQuery;
    TabExtra: TTabSheet;
    DBNavigator3: TDBNavigator;
    DBGrid3: TDBGrid;
    TblStruc: TTblStruc;
    DataSource: TDataSource;
    Table: TTable;
    DBKeyCombo: TDBKeyCombo;
    Label12: TLabel;
    DBComboBox1: TDBComboBox;
    Label13: TLabel;
    DBEdit1: TDBEdit;
    DBLocate: TDBLocate;
    TabBrowseAuthor: TTabSheet;
    DBGrid4: TDBGrid;
    RPanel5: TRPanel;
    DefineBtn: TButton;
    OpenBtn: TButton;
    Label11: TLabel;
    Edit1: TEdit;
    RPanel6: TRPanel;
    DBLocate1: TDBLocate;
    DBKeyCombo1: TDBKeyCombo;
    ProgressBar1: TProgressBar;
    DBGrid2: TDBGrid;
    Execute: TButton;
    AbortBtn: TButton;
    procedure DBGrid1DblClick(Sender: TObject);
    procedure DBKeyComboChange(Sender: TObject);
    procedure ExtractBtnClick(Sender: TObject);
    procedure AddBtnClick(Sender: TObject);
    procedure FileListBox1DblClick(Sender: TObject);
    procedure FileListBox1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
    procedure DBStatusNotifyStatus(var Abort: Boolean);
    procedure ExecuteClick(Sender: TObject);
    procedure Edit1Exit(Sender: TObject);
    procedure DefineBtnClick(Sender: TObject);
    procedure OpenBtnClick(Sender: TObject);
    procedure DBGrid4DblClick(Sender: TObject);
    procedure AbortBtnClick(Sender: TObject);
    procedure DBLocateSearchNotFound(Sender: TObject);
    procedure DBKeyCombo1Change(Sender: TObject);
    procedure DBLocateChange(Sender: TObject);
    procedure DBLocate1Change(Sender: TObject);
  private
    { Private declarations }
    AbortOperation : Boolean;
  public
    { Public declarations }
  end;

var
  FormComponent: TFormComponent;

implementation

uses DataModule_DMCOMP, Form_GenTest;

{$R *.DFM}

procedure TFormComponent.DBGrid1DblClick(Sender: TObject);
begin
     With DMComp do
     begin
          Comp.Locate('CompNo',QCompCompNo.AsInteger,[]);
     end;

     PageControl1.ActivePage := TabEdit;
end;

procedure TFormComponent.DBKeyComboChange(Sender: TObject);
begin
     DBLocate.SearchField := DBKeyCombo.SelectedField;
end;

procedure TFormComponent.ExtractBtnClick(Sender: TObject);
begin
     SaveDlg.FileName := DMComp.CompFileName.AsString;
     If SaveDlg.Execute then
     begin
          If FileExists(SaveDlg.FileName) then
          begin
               If MessageDlg('file exists, override ?',mtConfirmation, [mbYes, mbNo],0) = mrYes then
               begin
                    DMComp.CompComponent.SavetoFile(SaveDlg.FileName);
               end;
          end
          else
          begin
                    DMComp.CompComponent.SavetoFile(SaveDlg.FileName);
          end;
     end;
     FileListBox1.Update;
     
end;

procedure TFormComponent.AddBtnClick(Sender: TObject);
begin
     With DMComp do
     begin
          If not (Comp.State in [dsInsert, dsEdit]) then
          begin
               Comp.Edit;
          end;
          
          CompFileName.Value := FileListBox1.FileName;
          CompComponent.LoadFromFile(FileListBox1.FileName);

          Showmessage('File added, remember to post !');
     end;
end;

procedure TFormComponent.FileListBox1DblClick(Sender: TObject);
begin
     ShellExecute(Handle, 'Open', PChar(FileListBox1.FileName), '','',SW_Show);
end;

procedure TFormComponent.FileListBox1KeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
     If Key = vk_Delete then
     begin
          If MessageDlg('Delete file ?', mtConfirmation, [mbYes, mbNo],0) = mrYes then
          DeleteFile(FileListBox1.FileName);
          FileListbox1.Update;
          FileListBox1.FileName := FileListBox1.Items.Strings[FileListBox1.Items.Count - 1];
     end;
end;

procedure TFormComponent.FormCreate(Sender: TObject);
begin
     DMComp.COMPSource.OnDataChange(Nil,Nil);
     DBStatus.RegisterCall;
     AbortOperation := True;
end;



procedure TFormComponent.DBStatusNotifyStatus(var Abort: Boolean);
begin
     StatusBar.SimpleText := DBStatus.StatusMsg;
     ProgressBar1.Position := DBStatus.Percentage;

     If AbortOperation then
     Abort := true;
end;




procedure TFormComponent.ExecuteClick(Sender: TObject);
begin
     AbortOperation := False;
     QBuilder.Execute;
end;

procedure TFormComponent.Edit1Exit(Sender: TObject);
begin
     Table.TableName := Edit1.Text;
end;

procedure TFormComponent.DefineBtnClick(Sender: TObject);
begin
     If Edit1.Text <> '' then
     begin
          Table.Close;
          TblStruc.Execute;
          IF TblStruc.CreateTable then
          begin
               Showmessage('Table created');
          end
          else
          begin
               Showmessage('Fail to create table');
          end;
     end
     else
     begin
          Showmessage('Please Specify a table name');
     end;
end;

procedure TFormComponent.OpenBtnClick(Sender: TObject);
begin
     If Edit1.Text <> '' then
     begin
          Table.Open;
     end
     else
     begin
          Showmessage('Please Specify a table name');
     end;
end;



procedure TFormComponent.DBGrid4DblClick(Sender: TObject);
begin
     PageControl1.ActivePage := TabAuthor;
end;










procedure TFormComponent.AbortBtnClick(Sender: TObject);
begin
     AbortOperation := True;
     //Check DBStatus.NotifyStatus event for detail on
     //Thread Querying Abortion
end;






procedure TFormComponent.DBLocateSearchNotFound(Sender: TObject);
begin
     StatusBar.SimpleText := 'Not found !';
end;

procedure TFormComponent.DBKeyCombo1Change(Sender: TObject);
begin
     DBLocate1.SearchField := DBKeyCombo1.SelectedField;
end;

procedure TFormComponent.DBLocateChange(Sender: TObject);
begin
     StatusBar.SimpleText := '';
end;

procedure TFormComponent.DBLocate1Change(Sender: TObject);
begin
     StatusBar.SimpleText := '';
end;

end.
